/*****************************************************************************/
/*                                                                           */
/*  THE NONPAREIL DOCUMENT FORMATTING SYSTEM                                 */
/*  COPYRIGHT (C) 2002, 2005 Jeffrey H. Kingston                             */
/*                                                                           */
/*  Jeffrey H. Kingston (jeff@it.usyd.edu.au)                                */
/*  School of Information Technologies                                       */
/*  The University of Sydney 2006                                            */
/*  AUSTRALIA                                                                */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either Version 2, or (at your option)      */
/*  any later version.                                                       */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307 USA   */
/*                                                                           */
/*  FILE:         astring.h                                                  */
/*  DESCRIPTION:  7-bit Ascii strings (header file)                          */
/*                                                                           */
/*****************************************************************************/
#ifndef ASTRING_HEADER_FILE
#define ASTRING_HEADER_FILE
#include <stdio.h>
#include "boolean.h"
#include "array.h"
#include "utypes.h"

typedef ARRAY(ASTRING)	ARRAY_ASTRING;

/* operations for constructing temporary AStrings via a factory */
extern AFACTORY AStringBegin(void);
extern void AStringAddChar(AFACTORY af, char ch);
extern void AStringAddInt(AFACTORY af, int i);
extern void AStringAddHex(AFACTORY af, unsigned int hex);
extern void AStringAddAString(AFACTORY af, ASTRING str);
extern void AStringAddFmt1(AFACTORY af, ASTRING fmt, ASTRING p1);
extern void AStringAddFmt2(AFACTORY af, ASTRING fmt, ASTRING p1, ASTRING p2);
extern void AStringAddFmt3(AFACTORY af, ASTRING fmt, ASTRING p1, ASTRING p2,
  ASTRING p3);
extern void AStringAddFmt4(AFACTORY af, ASTRING fmt, ASTRING p1, ASTRING p2,
  ASTRING p3, ASTRING p4);
extern void AStringAddFmt5(AFACTORY af, ASTRING fmt, ASTRING p1, ASTRING p2,
  ASTRING p3, ASTRING p4, ASTRING p5);
extern ASTRING AStringEnd(AFACTORY af);

/* operations for constructing permanent AStrings */
extern ASTRING AStringCat(ASTRING str1, ASTRING str2);
extern ASTRING AStringCat3(ASTRING str1, ASTRING str2, ASTRING str3);
extern ASTRING AStringCat4(ASTRING str1, ASTRING str2, ASTRING str3,
  ASTRING str4);
extern ASTRING AStringCopy(ASTRING str);

/* miscellaneous */
extern BOOLEAN AStringEqual(ASTRING str1, ASTRING str2);
extern BOOLEAN AStringBeginsWith(ASTRING str1, ASTRING str2);
extern USTRING AStringToUString(ASTRING str);
extern int AStringHash(ASTRING str);

#endif
