/*****************************************************************************/
/*                                                                           */
/*  THE NONPAREIL DOCUMENT FORMATTING SYSTEM                                 */
/*  COPYRIGHT (C) 2002, 2005 Jeffrey H. Kingston                             */
/*                                                                           */
/*  Jeffrey H. Kingston (jeff@it.usyd.edu.au)                                */
/*  School of Information Technologies                                       */
/*  The University of Sydney 2006                                            */
/*  AUSTRALIA                                                                */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either Version 2, or (at your option)      */
/*  any later version.                                                       */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307 USA   */
/*                                                                           */
/*  FILE:         builtin.c                                                  */
/*  DESCRIPTION:  Nonpareil builtin expressions                              */
/*                                                                           */
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "externs.h"
#define DEBUG1 0
#define DEBUG2 0
#define DEBUG3 0


/*****************************************************************************/
/*                                                                           */
/*  BEFN_BUILTIN - a builtin C function                                      */
/*                                                                           */
/*****************************************************************************/

struct befn_builtin_rec {
  KIND_TAG		kind_tag;	/* kind of entity                    */
  CODEGEN_TYPE		be_type;	/* result type                       */
  CODEGEN_OBJ		be_obj;		/* corresponding backend function    */
  ARRAY_BEFN		inner_functs;	/* to generate just before this fn   */
  ARRAY_BEFN_PARAM	parameters;	/* ordinary params (NULL if none)    */
  CODEGEN_OBJ		inline_be_obj;	/* non-NULL if to be inlined         */
  BOOLEAN		utilized;	/* TRUE when has been called         */
  BOOLEAN		cached;		/* TRUE when calls are to be cached  */

  FEFN_BUILTIN		builtin_fn;	/* that originated this C function   */
};


/*****************************************************************************/
/*                                                                           */
/*  BEFN_BUILTIN BEFnBuiltinNew(FEFN_BUILTIN bf, CODEGEN_OBJ be_obj)         */
/*                                                                           */
/*  Return a new builtin C function for bf.                                  */
/*                                                                           */
/*****************************************************************************/

BEFN_BUILTIN BEFnBuiltinNew(FEFN_BUILTIN bf, CODEGEN_OBJ be_obj)
{
  BEFN_BUILTIN res;
  GetMemory(res, BEFN_BUILTIN);
  res->kind_tag = KIND_BEFN_BUILTIN;
  res->be_type = NULL;
  res->be_obj = be_obj;
  res->inner_functs = NULL;
  res->parameters = NULL;
  res->inline_be_obj = NULL;
  res->utilized = FALSE;
  res->cached = FALSE;
  res->builtin_fn = bf;
  return res;
}


/*****************************************************************************/
/*                                                                           */
/*  void BEFnBuiltinFinalize(BEFN_BUILTIN bcf, CODEGEN be)                   */
/*                                                                           */
/*  Finalize the be_type field of bcf (be_obj is already done).              */
/*                                                                           */
/*****************************************************************************/

void BEFnBuiltinFinalize(BEFN_BUILTIN bcf, CODEGEN be)
{
  bcf->be_type = TypeBEType(FEFnResultType((FEFN) bcf->builtin_fn), be);
  if( bcf->be_obj == NULL )
  {
    /* assert(bcf->builtin_fn->class_view != NULL); */
    bcf->be_obj = be->identity;
  }
}
