/*****************************************************************************/
/*                                                                           */
/*  THE NONPAREIL DOCUMENT FORMATTING SYSTEM                                 */
/*  COPYRIGHT (C) 2002, 2005 Jeffrey H. Kingston                             */
/*                                                                           */
/*  Jeffrey H. Kingston (jeff@it.usyd.edu.au)                                */
/*  School of Information Technologies                                       */
/*  The University of Sydney 2006                                            */
/*  AUSTRALIA                                                                */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either Version 2, or (at your option)      */
/*  any later version.                                                       */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307 USA   */
/*                                                                           */
/*  FILE:         befn_downdef.c                                             */
/*  DESCRIPTION:  Back-end downcast definitions                              */
/*                                                                           */
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "externs.h"


/*****************************************************************************/
/*                                                                           */
/*  BEFN_DOWNDEF                                                             */
/*                                                                           */
/*  A back-end downcast variable.                                            */
/*                                                                           */
/*****************************************************************************/

struct befn_downdef_rec {		/* inherits from BEFN		     */
  KIND_TAG		kind_tag;	/* kind of entity                    */
  CODEGEN_TYPE		be_type;	/* result type                       */
  CODEGEN_OBJ		be_obj;		/* corresponding backend function    */
  ARRAY_BEFN		inner_functs;	/* helpers; generate just before me  */
  ARRAY_BEFN_PARAM	parameters;	/* parameters (NULL if none)         */
  CODEGEN_OBJ		inline_be_obj;	/* non-NULL if to be inlined         */
  BOOLEAN		utilized;	/* TRUE when has been called         */
  BOOLEAN		cached;		/* TRUE when calls are to be cached  */

  FEFN_DOWNDEF		fefn_downdef;	/* the originating front-end downdef */
};


/*****************************************************************************/
/*                                                                           */
/*  BEFN_DOWNDEF BEFnDownDefMake(FEFN_DOWNDEF fefn_downdef,                  */
/*    CODEGEN_OBJ be_obj)                                                    */
/*                                                                           */
/*  Make a new back-end downdef corresponding to fefn_downdef.               */
/*                                                                           */
/*****************************************************************************/

BEFN_DOWNDEF BEFnDownDefMake(FEFN_DOWNDEF fefn_downdef, CODEGEN_OBJ be_obj)
{
  BEFN_DOWNDEF res;
  GetMemory(res, BEFN_DOWNDEF);
  res->kind_tag = KIND_BEFN_DOWNDEF;
  res->be_type = NULL;
  res->be_obj = be_obj;
  res->inner_functs = NULL;
  res->parameters = NULL;
  res->inline_be_obj = NULL;
  res->utilized = FALSE;
  res->cached = FALSE;
  res->fefn_downdef = fefn_downdef;
  return res;
}


/*****************************************************************************/
/*                                                                           */
/*  void BEFnDownDefFinalize(BEFN_DOWNDEF fun, CODEGEN be)                   */
/*                                                                           */
/*  Finalize fun.                                                            */
/*                                                                           */
/*****************************************************************************/

void BEFnDownDefFinalize(BEFN_DOWNDEF fun, CODEGEN be)
{
  fun->be_type = TypeBEType(FEFnResultType((FEFN) fun->fefn_downdef), be);
  assert(fun->be_obj != NULL);  /* fun->be_obj already done */
}
