/*****************************************************************************/
/*                                                                           */
/*  THE NONPAREIL DOCUMENT FORMATTING SYSTEM                                 */
/*  COPYRIGHT (C) 2002, 2005 Jeffrey H. Kingston                             */
/*                                                                           */
/*  Jeffrey H. Kingston (jeff@it.usyd.edu.au)                                */
/*  School of Information Technologies                                       */
/*  The University of Sydney 2006                                            */
/*  AUSTRALIA                                                                */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either Version 2, or (at your option)      */
/*  any later version.                                                       */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307 USA   */
/*                                                                           */
/*  FILE:         fefn_downdef.c                                             */
/*  DESCRIPTION:  Front-end downcast definitions                             */
/*                                                                           */
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "externs.h"


/*****************************************************************************/
/*                                                                           */
/*  FEFN_DOWNDEF                                                             */
/*                                                                           */
/*  A front-end downcast variable.                                           */
/*                                                                           */
/*****************************************************************************/

struct fefn_downdef_rec {		/* inherits from FEFN                */
  KIND_TAG		kind_tag;	/* kind of entity                    */
  FILE_POS		file_pos;	/* position of function name in file */
  NAME			name;		/* name of function                  */
  TYPE_VARS		type_vars;	/* generic parameters (NULL here)    */
  ARRAY_FEFN_PARAM	parameters;	/* ordinary params (NULL here)       */
  TYPE			result_type;	/* result type                       */
  BEFN_DOWNDEF		befn_downdef;	/* corresponding backend function    */
};


/*****************************************************************************/
/*                                                                           */
/*  FEFN_DOWNDEF FEFnDownDefMake(FILE_POS file_pos, NAME name,               */
/*    TYPE result_type)                                                      */
/*                                                                           */
/*  Return a new FEFN_DOWNDEF object with these attributes.                  */
/*                                                                           */
/*****************************************************************************/

FEFN_DOWNDEF FEFnDownDefMake(FILE_POS file_pos, NAME name, TYPE result_type)
{
  FEFN_DOWNDEF res;
  GetMemory(res, FEFN_DOWNDEF);
  res->kind_tag = KIND_FEFN_DOWNDEF;
  res->file_pos = file_pos;
  res->name = name;
  res->type_vars = NULL;
  res->parameters = NULL;
  res->result_type = result_type;
  res->befn_downdef = NULL;
  return res;
}


/*****************************************************************************/
/*                                                                           */
/*  void FEFnDownDefMakeBEFn(FEFN_DOWNDEF fefn_downdef, CODEGEN_OBJ be_var)  */
/*                                                                           */
/*  Make a corresponding backen downcast definition for fefn_downdef, with   */
/*  the given name.                                                          */
/*                                                                           */
/*****************************************************************************/

void FEFnDownDefMakeBEFn(FEFN_DOWNDEF fefn_downdef, CODEGEN_OBJ be_var)
{
  assert(fefn_downdef->befn_downdef == NULL);
  fefn_downdef->befn_downdef = BEFnDownDefMake(fefn_downdef, be_var);
}


/*****************************************************************************/
/*                                                                           */
/*  FEFN_DOWNDEF FEFnDownDefCopyUninstantiated(FEFN_DOWNDEF fefn_downdef,    */
/*    ARRAY_FEFN_PARAM orig_params, ARRAY_FEFN_PARAM copy_params)            */
/*                                                                           */
/*  Make a copy of uninstantiated downdef fefn_downdef.                      */
/*                                                                           */
/*****************************************************************************/

FEFN_DOWNDEF FEFnDownDefCopyUninstantiated(FEFN_DOWNDEF fefn_downdef,
  ARRAY_FEFN_PARAM orig_params, ARRAY_FEFN_PARAM copy_params)
{
  FEFN_DOWNDEF res;
  GetMemory(res, FEFN_DOWNDEF);
  res->kind_tag = KIND_FEFN_DOWNDEF;
  res->file_pos = fefn_downdef->file_pos;
  res->name = fefn_downdef->name;
  assert(fefn_downdef->type_vars == NULL);
  res->type_vars = NULL;
  assert(fefn_downdef->parameters == NULL);
  res->parameters = NULL;
  res->result_type = fefn_downdef->result_type == NULL ? NULL :
    TypeCopyUninstantiated(fefn_downdef->result_type);
  assert(fefn_downdef->befn_downdef == NULL);
  res->befn_downdef = NULL;
  return res;
}
