/*****************************************************************************/
/*                                                                           */
/*  THE NONPAREIL DOCUMENT FORMATTING SYSTEM                                 */
/*  COPYRIGHT (C) 2002, 2005 Jeffrey H. Kingston                             */
/*                                                                           */
/*  Jeffrey H. Kingston (jeff@it.usyd.edu.au)                                */
/*  School of Information Technologies                                       */
/*  The University of Sydney 2006                                            */
/*  AUSTRALIA                                                                */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either Version 2, or (at your option)      */
/*  any later version.                                                       */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307 USA   */
/*                                                                           */
/*  FILE:         iset.h                                                     */
/*  DESCRIPTION:  Interval sets, such as {0-6, 9-11, 12-65535}.              */
/*                                                                           */
/*****************************************************************************/
#ifndef ISET_HEADER_FILE
#define ISET_HEADER_FILE
#include <stdio.h>
#include "boolean.h"
#include "astring.h"

typedef struct iset_rec *ISET;

extern ISET ISetNew();
extern ISET ISetInterval(int from, int to);
extern void ISetInsert(ISET is1, int i);
extern void ISetUnion(ISET is1, ISET is2);
extern BOOLEAN ISetDisjointUnion(ISET is1, ISET is2, int *common_point);
extern void ISetInsertInterval(ISET is1, int from, int to);
extern int ISetMinElement(ISET is);
extern int ISetMaxElement(ISET is);
extern int ISetGap(ISET is, int width, int align);
extern ASTRING ISetShow(ISET is);
extern void ISetTest(FILE *fp);

#endif
