
/****************************************************************************/
/*                                                                          */
/*  npsys.h                                                                 */
/*                                                                          */
/*  Nonpareil runtime system                                                */
/*                                                                          */
/*  Jeffrey H. Kingston                                                     */
/*  March 2005                                                              */
/*                                                                          */
/*  This software has been placed in the public domain by its author.       */
/*                                                                          */
/****************************************************************************/

#ifndef npsys_header_file_seen
#define npsys_header_file_seen
#include <limits.h>
#include <stdlib.h>
#include "npsys_typedefs.h"
#include "lang.h"

/* various global constants */
#define false 0
#define true 1
#define DFT_PARAM_VAL (INT_MIN+1)

/* casts to and from float */
extern int float_to_int(float f);
extern void *float_to_voidp(float f);
extern float int_to_float(int i);
extern float voidp_to_float(void *v);

/* object memory systems */
extern MEM_SYS npsys_obj1;
extern MEM_SYS npsys_obj2;
extern bool mem_is_bigendian();
extern int mem_offset(MEM_SYS mem_sys, CACHE_OBJ obj);

/* current object memory system */
extern MEM_SYS npsys_obj;
extern CACHE_OBJ *npsys_obj_cache;
extern int npsys_obj_cache_len;
extern void npsys_obj_init(MEM_SYS *mem_sys);
extern CACHE_OBJ npsys_obj_new(size_t size);
extern void npsys_obj_free(void *obj, size_t size);
extern void npsys_obj_cache_insert(void *obj, int pos);

/* function call memory system */
extern MEM_SYS npsys_fun;
extern CACHE_FUN *npsys_fun_cache;
extern int npsys_fun_cache_len;
extern void npsys_fun_init(MEM_SYS *mem_sys);
extern CACHE_FUN npsys_fun_new(size_t size);
extern void npsys_fun_free(void *fun, size_t size);
extern void npsys_fun_cache_insert(void *fun, int pos);

/* array and stirng creation functions */
extern array array_create1(int length);
extern array array_create2(array self);
extern string string_create1(int length);
extern string string_create2(string self);

/* trie access operations */
#define trie1(t, i) (t)->elems[((int) i) & 0xFF]
#define trie2(t, i) trie1((array) (t)->elems[(((int) i) >>  8) & 0xFF], (int) i)
#define trie3(t, i) trie2((array) (t)->elems[(((int) i) >> 16) & 0xFF], (int) i)
#define trie4(t, i) trie3((array) (t)->elems[(((int) i) >> 24) & 0xFF], (int) i)

#endif
