
/****************************************************************************/
/*                                                                          */
/*  npsys_init.h                                                            */
/*                                                                          */
/*  Nonpareil runtime system (initialization of predefined objects)         */
/*                                                                          */
/*  Jeffrey H. Kingston                                                     */
/*  March 2005                                                              */
/*                                                                          */
/*  This software has been placed in the public domain by its author.       */
/*                                                                          */
/****************************************************************************/

#ifndef npsys_init_header_file_seen
#define npsys_init_header_file_seen
#include "lang.h"

/* swizzling */
extern int array_swizzle(array self, array other);
extern int string_swizzle(string self, string other);

/* helper functions for creating small strings */
extern string string_make0();
extern string string_make1(uchar c1);
extern string string_make2(uchar c1, uchar c2);
extern string string_make3(uchar c1, uchar c2, uchar c3);
extern string string_make4(uchar c1, uchar c2, uchar c3, uchar c4);
extern string string_make5(uchar c1, uchar c2, uchar c3, uchar c4, uchar c5);

/* null tries of height 1..4 */
extern array null_trie1;
extern array null_trie2;
extern array null_trie3;
extern array null_trie4;

/* all_enumerated initialization operations */
#define enum_set(array, index, code1, code2)				\
  array->elems[index] = pair_create((void *) code1, (void *) code2)

#define enum_set_seq(array, first_index, last_index, first_code)	\
{ int code;								\
  for( i=first_index, code=first_code; i <= last_index; i++, code++ )	\
    array->elems[i] = pair_create((void *) code, (void *) code);	\
}

/* enumerated class invariant checking */
#define enum_invt_seq(invt_fn, code1, code2)				\
{ unsigned code;							\
  for( code = code1;  code <= code2;  code++ )				\
    invt_fn(code);							\
}

/* swizzling operations */
#define swizzle_field(self_field, other_field, swizzle_offset)		\
offset1 = mem_offset(npsys_obj1, ((CACHE_OBJ) self_field));		\
offset2 = mem_offset(npsys_obj2, ((CACHE_OBJ) other_field));		\
assert((offset1 == offset2));						\
if( (self_field != other_field) )					\
{									\
  self->swizzle_bits |= 1 << swizzle_offset;				\
  self_field = (void *) mem_offset(npsys_obj1, (CACHE_OBJ) self_field);	\
}

#endif
