
/****************************************************************************/
/*                                                                          */
/*  npsys_load.h                                                            */
/*                                                                          */
/*  Nonpareil runtime system (loading of predefined objects)                */
/*                                                                          */
/*  Jeffrey H. Kingston                                                     */
/*  March 2005                                                              */
/*                                                                          */
/*  This software has been placed in the public domain by its author.       */
/*                                                                          */
/****************************************************************************/

#ifndef npsys_load_header_file_seen
#define npsys_load_header_file_seen
#include "typedefs.h"

/* array and string unswizzling functions */
extern int array_unswizzle(array self, char *mem);
extern int string_unswizzle(string self, char *mem);

/* unswizzling operation */
#define unswizzle_field(self_field, swizzle_offset)			\
if( (self->swizzle_bits >> swizzle_offset) & 1 )			\
  self_field = (void *) (mem + (int) self_field)

#endif
