
/****************************************************************************/
/*                                                                          */
/*  npsys_typedefs.h                                                        */
/*                                                                          */
/*  Nonpareil runtime system - typedefs                                     */
/*                                                                          */
/*  Jeffrey H. Kingston                                                     */
/*  March 2005                                                              */
/*                                                                          */
/*  This software has been placed in the public domain by its author.       */
/*                                                                          */
/****************************************************************************/

#ifndef npsys_typedefs_header_file_seen
#define npsys_typedefs_header_file_seen
#include <stdlib.h>
#include "lang.h"

/* a cached object - anything with a hash signature */
typedef struct cache_obj_rec {
  int	signature;
} *CACHE_OBJ;

/* a cached function call (inherits from CACHE_OBJ) */
typedef struct cache_fun_rec {
  int	signature;
  int 	elems[1];
} *CACHE_FUN;

/* a memory chunk */
typedef struct mem_chunk_rec {
  char *first;				/* first location of chunk          */
  char *free;				/* first free location in chunk     */
  char *top;				/* just past top of chunk           */
  struct mem_chunk_rec *prev_chunk;	/* previous chunk                   */
} *MEM_CHUNK;

/* a memory system - a collection of chunks, one of which is a cache */
typedef struct mem_sys_rec {
  MEM_CHUNK used_chunks;		/* chunks currently in use          */
  MEM_CHUNK free_chunks;		/* chunks currently free            */
  MEM_CHUNK cache_chunk;		/* chunk holding cache              */
  CACHE_OBJ *cache;			/* cache (points into cache_chunk)  */
  int cache_len;			/* length of cache                  */
  int cache_count;			/* no. of objects in cache          */
  int cache_maxcount;			/* max no. before resize            */
} *MEM_SYS;

#endif
