/*****************************************************************************/
/*                                                                           */
/*  THE NONPAREIL DOCUMENT FORMATTING SYSTEM                                 */
/*  COPYRIGHT (C) 2002, 2005 Jeffrey H. Kingston                             */
/*                                                                           */
/*  Jeffrey H. Kingston (jeff@it.usyd.edu.au)                                */
/*  School of Information Technologies                                       */
/*  The University of Sydney 2006                                            */
/*  AUSTRALIA                                                                */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either Version 2, or (at your option)      */
/*  any later version.                                                       */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307 USA   */
/*                                                                           */
/*  FILE:         np_back.c                                                  */
/*  DESCRIPTION:  Various backend entities needed by Nonpareil.              */
/*                                                                           */
/*****************************************************************************/
#include "externs.h"


/*****************************************************************************/
/*                                                                           */
/*  Files                                                                    */
/*                                                                           */
/*****************************************************************************/

CODEGEN_FILE NPBack_File_Stdlib;	/* "stdlib" file		*/
CODEGEN_FILE NPBack_File_Stdio;		/* "stdio" file			*/
CODEGEN_FILE NPBack_File_String;	/* "string" file		*/
CODEGEN_FILE NPBack_File_Limits;	/* "limits" file		*/
CODEGEN_FILE NPBack_File_Float;		/* "float" file			*/
CODEGEN_FILE NPBack_File_Math;		/* "math" file			*/
CODEGEN_FILE NPBack_File_Assert;	/* "assert" file		*/


/*****************************************************************************/
/*                                                                           */
/*  Types                                                                    */
/*                                                                           */
/*****************************************************************************/

CODEGEN_TYPE NPBack_Cache_Obj_Type;	/* CACHE_OBJ                    */
CODEGEN_TYPE NPBack_Cache_Fun_Type;	/* CACHE_FUN                    */


/*****************************************************************************/
/*                                                                           */
/*  Constants                                                                */
/*                                                                           */
/*****************************************************************************/

CODEGEN_OBJ NPBack_False;		/* false                        */
CODEGEN_OBJ NPBack_True;		/* true                         */
CODEGEN_OBJ NPBack_Dft_Param_Val;	/* default value for params     */


/*****************************************************************************/
/*                                                                           */
/*  Variables and functions (miscellaneous)                                  */
/*                                                                           */
/*****************************************************************************/

CODEGEN_OBJ NPBack_Self;		/* self                         */
CODEGEN_OBJ NPBack_Other;		/* other			*/
CODEGEN_OBJ NPBack_Res;			/* res				*/
CODEGEN_OBJ NPBack_NPSysObj1;		/* npsys_obj1                   */
CODEGEN_OBJ NPBack_NPSysObj2;		/* npsys_obj2                   */
CODEGEN_OBJ NPBack_I;			/* i				*/
CODEGEN_OBJ NPBack_Code;		/* code				*/
CODEGEN_OBJ NPBack_Sig;			/* sig				*/
CODEGEN_OBJ NPBack_Mem;			/* mem				*/
CODEGEN_OBJ NPBack_Obj_Cache;		/* npsys_obj_cache		*/
CODEGEN_OBJ NPBack_Obj_Cache_Insert;	/* npsys_obj_cache_insert(..)	*/
CODEGEN_OBJ NPBack_Obj_New;		/* npsys_obj_new(..)		*/
CODEGEN_OBJ NPBack_Obj_Cache_Len;	/* npsys_obj_cache_len		*/
CODEGEN_OBJ NPBack_Fun_Cache;		/* npsys_fun_cache		*/
CODEGEN_OBJ NPBack_Fun_Cache_Insert;	/* npsys_fun_cache_insert(..)	*/
CODEGEN_OBJ NPBack_Fun_New;		/* npsys_fun_new(..)		*/
CODEGEN_OBJ NPBack_Fun_Cache_Len;	/* npsys_fun_cache_len		*/
CODEGEN_OBJ NPBack_Trie[4];		/* trie1, ... trie4 macros      */
CODEGEN_OBJ NPBack_SubTrie[4];		/* val, subtrie1, ... subtrie3  */
CODEGEN_OBJ NPBack_NullTrie[4];		/* be->null_value .. null_trie3 */
CODEGEN_OBJ NPBack_Signature;		/* $1->signature		*/
CODEGEN_OBJ NPBack_Type_Tag;		/* $1->type_tag			*/
CODEGEN_OBJ NPBack_Swizzle_Bits;	/* $1->swizzle_bits		*/
CODEGEN_OBJ NPBack_Array_Length;	/* $1->length			*/
CODEGEN_OBJ NPBack_Array_Get;		/* $1->elems[$2]		*/
CODEGEN_OBJ NPBack_EnumSet;		/* enum_set($1, ... , $n)       */
CODEGEN_OBJ NPBack_EnumSetSeq;		/* enum_set_seq($1, ... , $n)   */
CODEGEN_OBJ NPBack_EnumInvtSeq;		/* enum_invt_seq($1, ... , $n)  */
CODEGEN_OBJ NPBack_Swizzle_Field;	/* swizzle_field($1, $2, $3)    */
CODEGEN_OBJ NPBack_Unswizzle_Field;	/* unswizzle_field($1, $2)      */


/*****************************************************************************/
/*                                                                           */
/*  Array and string creation functions                                      */
/*                                                                           */
/*****************************************************************************/

CODEGEN_OBJ NPBack_Array_Create_Fn1;
CODEGEN_OBJ NPBack_Array_Create_Fn2;
CODEGEN_OBJ NPBack_String_Create_Fn1;
CODEGEN_OBJ NPBack_String_Create_Fn2;
CODEGEN_OBJ NPBack_String_Make0;
CODEGEN_OBJ NPBack_String_Make1;
CODEGEN_OBJ NPBack_String_Make2;
CODEGEN_OBJ NPBack_String_Make3;
CODEGEN_OBJ NPBack_String_Make4;
CODEGEN_OBJ NPBack_String_Make5;


/*****************************************************************************/
/*                                                                           */
/*  void NPBackInit(CODEGEN be)                                              */
/*                                                                           */
/*  Initialize this module.                                                  */
/*                                                                           */
/*****************************************************************************/

void NPBackInit(CODEGEN be)
{
  /* files */
  NPBack_File_Stdlib = be->FileMake(AStringToUString("stdlib"), TRUE, FALSE);
  NPBack_File_Stdio = be->FileMake(AStringToUString("stdio"), TRUE, FALSE);
  NPBack_File_String = be->FileMake(AStringToUString("string"), TRUE, FALSE);
  NPBack_File_Limits = be->FileMake(AStringToUString("limits"), TRUE, FALSE);
  NPBack_File_Float = be->FileMake(AStringToUString("float"), TRUE, FALSE);
  NPBack_File_Math = be->FileMake(AStringToUString("math"), TRUE, FALSE);
  NPBack_File_Assert = be->FileMake(AStringToUString("assert"), TRUE, FALSE);

  /* types */
  NPBack_Cache_Obj_Type = be->TypeMakeObject(AStringToUString("CACHE_OBJ"));
  NPBack_Cache_Fun_Type = be->TypeMakeObject(AStringToUString("CACHE_FUN"));

  /* constants */
  NPBack_False = be->ConstMakeInt("false", NULL, 0, TRUE);
  NPBack_True = be->ConstMakeInt("true", NULL, 1, TRUE);
  NPBack_Dft_Param_Val =
    be->ConstMakeAString("DFT_PARAM_VAL", NULL, "(MIN_INT + 1)", TRUE);

  /* variables and functions (miscellaneous) */
  NPBack_Self = be->VarMake("self", NULL);
  NPBack_Other = be->VarMake("other", NULL);
  NPBack_Res = be->VarMake("res", NULL);
  NPBack_NPSysObj1 = be->VarMake("npsys_obj1", NULL);
  NPBack_NPSysObj2 = be->VarMake("npsys_obj2", NULL);
  NPBack_I = be->VarMake("i", NULL);
  NPBack_Code = be->VarMake("code", NULL);
  NPBack_Sig = be->VarMake("sig", NULL);
  NPBack_Mem = be->VarMake("mem", NULL);
  NPBack_Obj_Cache = be->VarMake("npsys_obj_cache", NULL);
  NPBack_Obj_Cache_Insert =be->FunctionMake("npsys_obj_cache_insert",TRUE,TRUE);
  NPBack_Obj_New = be->FunctionMake("npsys_obj_new", TRUE, TRUE);
  NPBack_Obj_Cache_Len = be->VarMake("npsys_obj_cache_len", NULL);
  NPBack_Fun_Cache = be->VarMake("npsys_fun_cache", NULL);
  NPBack_Fun_Cache_Insert =be->FunctionMake("npsys_fun_cache_insert",TRUE,TRUE);
  NPBack_Fun_New = be->FunctionMake("npsys_fun_new", TRUE, TRUE);
  NPBack_Fun_Cache_Len = be->VarMake("npsys_fun_cache_len", NULL);
  NPBack_Trie[0] = be->FunctionMake("trie1", TRUE, TRUE);
  NPBack_Trie[1] = be->FunctionMake("trie2", TRUE, TRUE);
  NPBack_Trie[2] = be->FunctionMake("trie3", TRUE, TRUE);
  NPBack_Trie[3] = be->FunctionMake("trie4", TRUE, TRUE);
  NPBack_SubTrie[0] = be->VarMake("val", NULL);
  NPBack_SubTrie[1] = be->VarMake("sub_trie1", NULL);
  NPBack_SubTrie[2] = be->VarMake("sub_trie2", NULL);
  NPBack_SubTrie[3] = be->VarMake("sub_trie3", NULL);
  NPBack_NullTrie[0] = be->null_value;
  NPBack_NullTrie[1] = be->VarMake("null_trie1", NULL);
  NPBack_NullTrie[2] = be->VarMake("null_trie2", NULL);
  NPBack_NullTrie[3] = be->VarMake("null_trie3", NULL);
  NPBack_Type_Tag = be->StructItemMake(AStringToUString("type_tag"), -1);
  NPBack_Signature = be->StructItemMake(AStringToUString("signature"), -1);
  NPBack_Swizzle_Bits =be->StructItemMake(AStringToUString("swizzle_bits"), -1);
  NPBack_Array_Length = be->AttrMake("length");
  NPBack_Array_Get = be->FunctionAttributeIndexed("elems");
  NPBack_EnumSet = be->FunctionMake("enum_set", TRUE, TRUE);
  NPBack_EnumSetSeq = be->FunctionMake("enum_set_seq", TRUE, TRUE);
  NPBack_EnumInvtSeq = be->FunctionMake("enum_invt_seq", TRUE, TRUE);
  NPBack_Swizzle_Field = be->FunctionMake("swizzle_field", TRUE, TRUE);
  NPBack_Unswizzle_Field = be->FunctionMake("unswizzle_field", TRUE, TRUE);

  /* array and string creation functions */
  NPBack_Array_Create_Fn1 = be->FunctionMake("array_create1", TRUE, TRUE);
  NPBack_Array_Create_Fn2 = be->FunctionMake("array_create2", TRUE, TRUE);
  NPBack_String_Create_Fn1 = be->FunctionMake("string_create1", TRUE, TRUE);
  NPBack_String_Create_Fn2 = be->FunctionMake("string_create2", TRUE, TRUE);
  NPBack_String_Make0 = be->FunctionMake("string_make0", TRUE, TRUE);
  NPBack_String_Make1 = be->FunctionMake("string_make1", TRUE, TRUE);
  NPBack_String_Make2 = be->FunctionMake("string_make2", TRUE, TRUE);
  NPBack_String_Make3 = be->FunctionMake("string_make3", TRUE, TRUE);
  NPBack_String_Make4 = be->FunctionMake("string_make4", TRUE, TRUE);
  NPBack_String_Make5 = be->FunctionMake("string_make5", TRUE, TRUE);

  /* trie access functions */
}
