/*****************************************************************************/
/*                                                                           */
/*  THE NONPAREIL DOCUMENT FORMATTING SYSTEM                                 */
/*  COPYRIGHT (C) 2002, 2005 Jeffrey H. Kingston                             */
/*                                                                           */
/*  Jeffrey H. Kingston (jeff@it.usyd.edu.au)                                */
/*  School of Information Technologies                                       */
/*  The University of Sydney 2006                                            */
/*  AUSTRALIA                                                                */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either Version 2, or (at your option)      */
/*  any later version.                                                       */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307 USA   */
/*                                                                           */
/*  FILE:         trie.h                                                     */
/*  DESCRIPTION:  Four-level trie.                                           */
/*                                                                           */
/*****************************************************************************/
#ifndef TRIE_HEADER_FILE
#define TRIE_HEADER_FILE
#include "ustring.h"
#include <stdio.h>

typedef struct init_trie_rec *INIT_TRIE;
typedef struct trie_rec *TRIE;

extern INIT_TRIE TrieNew(size_t size, int(*compar)(const void *, const void *),
  void(*value_debug)(void *, FILE *), void *default_value);
extern void TrieInsert(INIT_TRIE trie, unsigned int first_key,
  unsigned int last_key, void *value);
extern void *TrieInitRetrieve(INIT_TRIE trie, unsigned int key);
extern void TrieSave(INIT_TRIE trie, USTRING file_name);
extern TRIE TrieRestore(USTRING file_name);
extern unsigned int TrieMaxKey(TRIE trie);
extern void *TrieRetrieve(TRIE trie, unsigned int key);
extern void TrieInitDebug(INIT_TRIE trie, FILE *fp);
extern void TrieDebug(TRIE trie, FILE *fp);

#endif
