/*****************************************************************************/
/*                                                                           */
/*  THE NONPAREIL DOCUMENT FORMATTING SYSTEM                                 */
/*  COPYRIGHT (C) 2002, 2005 Jeffrey H. Kingston                             */
/*                                                                           */
/*  Jeffrey H. Kingston (jeff@it.usyd.edu.au)                                */
/*  School of Information Technologies                                       */
/*  The University of Sydney 2006                                            */
/*  AUSTRALIA                                                                */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either Version 2, or (at your option)      */
/*  any later version.                                                       */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307 USA   */
/*                                                                           */
/*  FILE:         ustring.h                                                  */
/*  DESCRIPTION:  32-bit Unicode strings (header file)                       */
/*                                                                           */
/*****************************************************************************/
#ifndef USTRING_HEADER_FILE
#define USTRING_HEADER_FILE
#include <stdio.h>
#include "boolean.h"
#include "utypes.h"
#include "uchar.h"
#include "astring.h"

typedef ARRAY(USTRING)	ARRAY_USTRING;

/* build up UString char by char */
extern void UStringBeginWithSize(int size);
extern void UStringBegin(void);
extern void UStringAdd(UCHAR ch);
extern void UStringAppend(USTRING str);
extern USTRING UStringEnd(void);

/* the empty string (shared) */
extern USTRING UStringEmpty(void);

/* the max string, larger than any legal string (shared) */
extern USTRING UStringMax(void);

/* conversions to ASTRING */
extern ASTRING UStringToDisplayedHex(USTRING str);
extern ASTRING UStringNumberToAString(USTRING str);

/* conversions between numbers and USTRING */
extern BOOLEAN UStringMakeInteger(USTRING str, int *res);
extern int UStringToInteger(USTRING str);
extern USTRING UStringFromInteger(int i);

/* conversions between USTRING and UTF8 */
extern UTF8 UStringToUTF8(USTRING str);
extern UTF8 UStringToUTF8Quoted(USTRING str);

/* UString construction */
extern USTRING UStringCat(USTRING str1, USTRING str2);
extern USTRING UStringCat3(USTRING str1, USTRING str2, USTRING str3);
extern USTRING UStringCat4(USTRING str1, USTRING str2, USTRING str3,
  USTRING str4);
extern USTRING UStringCopy(USTRING str);
extern USTRING UStringSubstring(USTRING s, int start_pos, int len);
extern ARRAY_USTRING UStringSplit(USTRING s, UCHAR split_char);

/* UString query and searching */
extern int UStringLength(USTRING s);
extern UCHAR UStringGet(USTRING s, int i);
extern UCHAR UStringGetLast(USTRING s);
extern int UStringCmp(USTRING s1, USTRING s2);
extern int UStringLexicalCmp(const void *t1, const void *t2);
extern BOOLEAN UStringContains(USTRING s, UCHAR ch);
extern BOOLEAN UStringBeginsWith(USTRING str1, USTRING str2);
extern BOOLEAN UStringEndsWith(USTRING str1, USTRING str2);
extern BOOLEAN UStringEqual(USTRING str1, USTRING str2);
extern int UStringHash(USTRING s);

#endif
