/*****************************************************************************/
/*                                                                           */
/*  THE NONPAREIL DOCUMENT FORMATTING SYSTEM                                 */
/*  COPYRIGHT (C) 2002, 2005 Jeffrey H. Kingston                             */
/*                                                                           */
/*  Jeffrey H. Kingston (jeff@it.usyd.edu.au)                                */
/*  School of Information Technologies                                       */
/*  The University of Sydney 2006                                            */
/*  AUSTRALIA                                                                */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either Version 2, or (at your option)      */
/*  any later version.                                                       */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307 USA   */
/*                                                                           */
/*  FILE:         ustring_pool.h                                             */
/*  DESCRIPTION:  Pool of USTRING objects, indexed by unsigned short.        */
/*                                                                           */
/*****************************************************************************/
#ifndef USTRING_POOL_HEADER_FILE
#define USTRING_POOL_HEADER_FILE
#include <stdio.h>
#include "utypes.h"

extern USTRING_POOL UStringPoolNew();
extern USTRING_POOL_INDEX UStringPoolAdd(USTRING_POOL pool, USTRING str);
extern void UStringPoolSave(USTRING_POOL pool, USTRING file_name);
extern USTRING_POOL UStringPoolRestore(USTRING file_name);
extern USTRING UStringPoolGet(USTRING_POOL pool, USTRING_POOL_INDEX index);
extern void UStringPoolDebug(USTRING_POOL pool, int indent, FILE *fp);
extern void UStringPoolTest(USTRING_POOL pool, USTRING file_name, int indent,
  FILE *fp);

#endif
