
/*****************************************************************************/
/*                                                                           */
/*  THE NONPAREIL DOCUMENT FORMATTING SYSTEM                                 */
/*  COPYRIGHT (C) 2002, 2005 Jeffrey H. Kingston                             */
/*                                                                           */
/*  Jeffrey H. Kingston (jeff@it.usyd.edu.au)                                */
/*  School of Information Technologies                                       */
/*  The University of Sydney 2006                                            */
/*  AUSTRALIA                                                                */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either Version 2, or (at your option)      */
/*  any later version.                                                       */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307 USA   */
/*                                                                           */
/*  FILE:         utypes.h                                                   */
/*  DESCRIPTION:  Declarations of the various character and string types     */
/*                                                                           */
/*  These declarations would ideally be placed in the header files of the    */
/*  various string classes, but dependencies make that hard to get right.    */
/*                                                                           */
/*****************************************************************************/
#ifndef UTYPES_HEADER_FILE
#define UTYPES_HEADER_FILE
/* #include "array.h" */

/* character types */
typedef unsigned int	UCHAR;		/* unsigned 31-bit ISO 10646 char    */
typedef unsigned char	UTF8CHAR;	/* unsigned 8-bit UTF8 character     */
typedef char		ACHAR;		/* traditional 7-bit ASCII character */

/* string types */
typedef UCHAR *		USTRING;	/* unsigned 31-bit ISO 10646 string  */
typedef UTF8CHAR *	UTF8;		/* unsigned 8-bit UTF8 string        */
typedef ACHAR *		ASTRING;	/* traditional 7-bit ASCII string    */

/* string pools (for uniquefying strings) */
typedef struct ustring_pool_rec *USTRING_POOL;
typedef unsigned short USTRING_POOL_INDEX;

/* string factories (for building ASCII strings a bit at a time) */
typedef struct afactory_rec *AFACTORY;

#endif
