@SubAppendix
    @Title { Function classes }
    @Tag { standard.fun }
@Begin
@LP
Functions in Nonpareil have types
function.type @Index { Function type }
fun1 @Index { @Nonpareil { fun1 } class }
@ID @Nonpareil {
fun1{X1, T}
fun2{X1, X2, T}
...
}
depending on the number of parameters.  These @I { abstract function classes }
abstract.function.class @Index { Abstract function class }
are the only function classes that users need to know about.  However, the
core module contains two other families of function classes,
@I { function representation classes } and @I { function currying classes }.
@PP
There is one function representation class for each possible number of
function.representation.class @Index { Function representation class }
function parameters.  For example, here is the class of representations
of functions that have four parameters:
@QD @Box 0.8v @Break @HExpand @Nonpareil {
class fun4_rep{X1, X2, X3, X4, T}

    builtin

noncreation

    call(x1: X1, x2: X2, x3: X3, x4: X4): T :=
	builtin "fun4_rep_call"(x1, x2, x3, x4)

end
}
The pattern for any number of parameters should be clear.  In each case
the builtin state consists of just the C function pointer, nothing else.
As shown, the only operation available is to call the function with the
exact number of parameters it expects.
@PP
A function may be called with fewer than the declared number of parameters,
producing currying.  The abstract function classes define this behaviour:
@QD @Box 0.8v @Break @HExpand @Nonpareil {
class fun4{X1, X2, X3, X4, T}

noncreation

    apply1(x1: X1): fun3{X2, X3, X4, T}

    apply2(x1: X1, x2: X2): fun2{X3, X4, T}

    apply3(x1: X1, x2: X2, x3: X3): fun1{X4, T}

    apply4(x1: X1, x2: X2, x3: X3, x4: X4): T

end
}
Applying one, two, or three parameters produces for result a function of
three, two, or one parameters, whereas applying four parameters produces
an object of the result type, @Nonpareil { T }.
@PP
In between this abstract class family and the representation
family come the function currying classes representing curried
function.currying.class @Index { Function currying class }
functions.  Objects of these classes are the curried function
records well known in implementing functional languages:  they
hold the function pointer and whatever curried parameters have
been accumulated so far.
@PP
The general name for a class in this intermediate family is
@Nonpareil { funn_m }.  Each such class holds a pointer to a
function expecting @E { n } parameters, plus it holds @E { n - m }
curried parameters which will be the first @Nonpareil { n - m }
parameters supplied to the function when it is eventually called.
Since this leaves @E { m } parameters still to be supplied,
abstractly this class represents a function requiring @E { m }
parameters, where @E { 1 <= m <= n }, so it is an implementation
of the abstract class @Nonpareil { funm }.  
@PP
For example, here is the family of four classes @Nonpareil { fun4_1 },
@Nonpareil { fun4_2 }, @Nonpareil { fun4_3 }, and @Nonpareil { fun4_4 }:
@QuotedList

@LI @Box 0.8v @Break @HExpand @Nonpareil {
class fun4_1{X1, X2, X3, X4, T} inherit fun1{X4, T}

    rep: fun4_rep{X1, X2, X3, X4, T}

    x1: X1

    x2: X2

    x3: X3

noncreation

    apply1(x4: X4): T := rep.call(x1, x2, x3, x4)

end
}

@LI @Box 0.8v @Break @HExpand @Nonpareil {
class fun4_2{X1, X2, X3, X4, T} inherit fun2{X3, X4, T}

    rep: fun4_rep{X1, X2, X3, X4, T}

    x1: X1

    x2: X2

noncreation

    apply1(x3: X3) := fun4_1{X1, X2, X3, X4, T}(rep, x1, x2, x3)

    apply2(x3: X3, x4: X4): T := rep.call(x1, x2, x3, x4)

end
}

@LI @Box 0.8v @Break @HExpand @Nonpareil {
class fun4_3{X1, X2, X3, X4, T} inherit fun3{X2, X3, X4, T}

    rep: fun4_rep{X1, X2, X3, X4, T}

    x1: X1

noncreation

    apply1(x2: X2) := fun4_2{X1, X2, X3, X4, T}(rep, x1, x2)

    apply2(x2: X2, x3: X3):= fun4_1{X1, X2, X3, X4, T}(rep, x1, x2, x3)

    apply3(x2: X2, x3: X3, x4: X4): T := rep.call(x1, x2, x3, x4)

end
}

@LI @Box 0.8v @Break @HExpand @Nonpareil {
class fun4_4{X1, X2, X3, X4, T} inherit fun4{X1, X2, X3, X4, T}

    rep: fun4_rep{X1, X2, X3, X4, T}

noncreation

    apply1(x1: X1) := fun4_3{X1, X2, X3, X4, T}(rep, x1)

    apply2(x1: X1, x2: X2):= fun4_2{X1, X2, X3, X4, T}(rep, x1, x2)

    apply3(x1: X1, x2: X2, x3: X3): T := fun4_1{X1, X2, X3, X4, T}(rep, x1, x2, x3)

    apply4(x1: X1, x2: X2, x3: X3, x4: X4): T := rep.call(x1, x2, x3, x4)

end
}

@EndList
These concrete classes give the compiler a simple target when it is
compiling curried code:  if the function has @E { n } parameters
but only @E { n - m } are supplied in the call, then the code to
generate is an object creation call of class @Nonpareil { funn_m }.
For example, suppose @Nonpareil { f } is a function with four
parameters and the call @Nonpareil { f(e1, e2) } is made.  Then the
code generated by the compiler is just
@ID @Nonpareil { fun4_2("f", e1, e2) }
where @Nonpareil { "f" } stands for the unrepresentable address of
function @Nonpareil { f }.
@End @SubAppendix
